<?php

/**
 * Dragonbyte-Tech.com Downloads Mod 1.0.0
 * 
 * @author David Tobin
 * @copyright 2010
 * @version 1.0
 * 
 * You may not copy/reproduce any part of this file in whole or significant part.
 * 
 * All rights reserved.
 */

class Downloads {
	/**
	 * 
	 * Holds vBulletins Registry
	 * @var unknown_type
	 */
	private static $registry;
	/**
	 * 
	 * Holds the project home
	 * @var string
	 */
	private static $projectHome 	= '';
	/**
	 * 
	 * Holds the project pro home
	 * @var string
	 */
	private static $projectProHome	= '';
	/**
	 * 
	 * Is the user a moderator?
	 * @var boolean
	 */
	private static $moderator		= false;
	/**
	 * 
	 * Have we already called init()?
	 * @var boolean
	 */
	private static $inited			= false;
	/**
	 * 
	 * Holds module permissions
	 * @var array
	 */
	private static $permissions		= array();
	
	/**
	 * 
	 * Are we uploading with flash?
	 * @var boolean
	 */
	private static $flashing 		= false;
	
	public static function init($registry) {
		if (self::$inited == false) {
			self::$registry 		= $registry;
			
			self::$projectHome 		= DIR . '/dbtech/downloads';
			self::$projectProHome 	= DIR . '/dbtech/downloads_pro';
			
			($hook = vBulletinHook::fetch_hook('dbtech_downloads_class_download_init')) ? eval($hook) : false;
			
			if ($_GET['flashupload'] == 1) {
				self::$flashing = true;
			}
			
			if ($_GET['do'] == 'file' && ($_GET['image'] == 1 || $_GET['thumb'] == 1)) {
				self::$flashing = true;
			}
			
			if (!empty(self::$registry->dbtech_downloads_modules)) {
				self::$permissions		= self::$registry->dbtech_downloads_modules;
			} else {
				$fetchpermissions = self::$registry->db->query_read("
					SELECT * FROM " . TABLE_PREFIX . "dbtech_downloads_modules
				");
				
				$permcache = array();
				if (self::$registry->db->num_rows($fetchpermissions) > 0) {
					while ($perm = self::$registry->db->fetch_array($fetchpermissions)) {
						$permcache[$perm['moduleid']] = $perm;
					}
					
					self::$permissions = $permcache;
				} else {
					if (THIS_SCRIPT == 'downloads') {
						standard_error('You must configure each of the download modules in the Downloads section of your administrators control panel.');
					}
				}
			}
			
			$secondary = explode(',', self::$registry->userinfo['membergroupids']);
			
			$moderate = false;
			foreach ($secondary AS $ugid) {
				if (in_array($ugid, (array)unserialize(self::$permissions['modcp']['permissions'])) && count(unserialize(self::$permissions['modcp']['permissions'])) > 0) {
					if ($ugid != 1) {
						$moderate = true;
					}
				}
			}
			
			if (in_array(self::$registry->userinfo['usergroupid'], (array)unserialize(self::$permissions['modcp']['permissions'])) || $moderate == true) {
				self::$moderator = true;
			}
			
			self::$inited = true;
		}
	}
	
	public static function load_module($module) {
		if ($module != 'modcp') {	
			$secondary = explode(',', self::$registry->userinfo['membergroupids']);
			
			$access = false;
			foreach ($secondary AS $ugid) {
				if (in_array($ugid, (array)unserialize(self::$permissions[$module]['permissions'])) && count(unserialize(self::$permissions[$module]['permissions'])) > 0) {
					$access = true;
				}
			}
			
			if (self::$flashing == false && (empty(self::$permissions) || (!in_array(self::$registry->userinfo['usergroupid'], (array)unserialize(self::$permissions[$module]['permissions'])) && $access == false))) {
				self::throw_error('dbtech_downloads_no_authorisation');
			}
		} else {
			if (self::$moderator == false && self::$flashing == false) {
				self::throw_error('dbtech_downloads_no_authorisation');
			}	
		}
		
		if (!file_exists(self::$projectHome . '/modules/' . $module . 'Module.php')) {
			return false;
		} else {
			if (file_exists(self::$projectProHome . '/modules/' . $module . 'Module.php')) {
				require_once(self::$projectHome . '/modules/' . $module . 'Module.php');
				require_once(self::$projectProHome . '/modules/' . $module . 'Module.php');
				$classname = $module . 'Module_Pro';
				
				return new $classname(self::$registry); 
			} else {
				require_once(self::$projectHome . '/modules/' . $module . 'Module.php');
				
				$classname = $module . 'Module';
				return new $classname(self::$registry);
			}
		}
		
	if (file_exists(self::$projectProHome . '/modules/' . $module . 'Module.php')) {
				require_once(self::$projectHome . '/modules/' . $module . 'Module.php');
				require_once(self::$projectProHome . '/modules/' . $module . 'Module.php');
				$classname = $module . 'Module_Pro';
				
				return new $classname(self::$registry); 
			} else {
				require_once(self::$projectHome . '/modules/' . $module . 'Module.php');
				
				$classname = $module . 'Module';
				return new $classname(self::$registry);
			}
	}
	
	public static function can($module) {
		$secondary = explode(',', self::$registry->userinfo['membergroupids']);
			
		$access = false;
		foreach ($secondary AS $ugid) {
			if (in_array($ugid, (array)unserialize(self::$permissions[$module]['permissions']))) {
				$access = true;
			}
		}
		
		if (empty(self::$permissions) || (!in_array(self::$registry->userinfo['usergroupid'], (array)unserialize(self::$permissions[$module]['permissions'])) && $access == false)) {
			return false;
		} else {
			return true;
		}
	}
	
	public static function throw_error($phrase) {
		if (self::$flashing == false) {
			standard_error(fetch_error($phrase));
		} else {
			
		}
	}
	
	public static function convert_filesize($size, $round=2) {
		$size = floatval($size);
		
		$b	= 1;
		$kb = 1 * 1024;
		$mb = $kb * 1024;
		$gb = $mb * 1024;
		
		if ($size < $mb) {
			$size = round($size / $kb, $round) . 'KB';
		} else if ($size >= $mb && $size < $gb) {
			$size = round($size / $mb, $round) . 'MB';
		} else {
			$size = round($size / $gb, $round) . 'GB';
		}
		
		return $size;
	}
	
	public static function beautify_rating($rating) {
		$rating = intval($rating);
		
		if ($rating == 0) {
			$rating = '<span style="color: gray;" id="ratingsign"></span><span id="rating" style="color: gray;">' . $rating . '</span>';
		} else if ($rating > 0) {
			$rating = '<span style="color: green;" id="ratingsign">+</span><span id="rating" style="color: green;">' . $rating . '</span>';
		} else if ($rating < 0) {
			$rating = '<span style="color: red;" id="ratingsign"></span><span id="rating" style="color: red;">' . $rating . '</span>';
		}
		
		return $rating;
	}
	
	public static function is_mod() {
		if (self::$moderator == 1) {
			return true;
		} else {
			return false;
		}
	}
	
	public static function register_display_vars($template) {
		$display = array();
		
		foreach (self::$permissions AS $moduleid => $permissions) {
			if (self::can($moduleid)) {
				if ($moduleid == 'global') $moduleid = 'check';
				
				$display[$moduleid] = true;
			} else {
				if ($moduleid == 'global') $moduleid = 'check';
				
				$display[$moduleid] = false;
			}
		}
		
		$template->register('display', $display);
		return $display;
	}
	
	public static function convert_wysiwyg_html_to_bbcode($html) {
		if (!file_exists(DIR . '/includes/functions_wysiwyg.php'))
		{
			require_once(DIR . '/includes/class_wysiwygparser.php');
			$html_parser = new vB_WysiwygHtmlParser(self::$registry);
			$message = $html_parser->parse_wysiwyg_html_to_bbcode($html, false);
		}
		else
		{
			require_once(DIR . '/includes/functions_wysiwyg.php');
			$message = convert_wysiwyg_html_to_bbcode($html);
		}
		
		return $message;
	}
}


?>